/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;

public class ConfigUpdater {
    public static void updateConfigs() {
        String version = ModList.get().getModFileById("cold_sweat").versionString();
        if (version.equals("0.0NONE")) {
            return;
        }
        String configVersion = MainSettingsConfig.getInstance().getVersion();
        ItemSettingsConfig itemSettings = ItemSettingsConfig.getInstance();
        WorldSettingsConfig worldSettings = WorldSettingsConfig.getInstance();
        if (ConfigUpdater.isBehind(configVersion, "2.3-b01a")) {
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, List.of("cold_sweat:chameleon_molt", Integer.valueOf(2), Double.valueOf(0.0085), "adaptive"));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3-b04a")) {
            ConfigUpdater.addConfigSetting(ItemSettingsConfig.FOOD_TEMPERATURES, List.of("cold_sweat:soul_sprout", Double.valueOf(0.0), "{}", Integer.valueOf(1200)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:lava_cauldron", Double.valueOf(0.5), Integer.valueOf(7), Boolean.valueOf(true), Double.valueOf(1.5)));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3-b05b")) {
            ConfigUpdater.removeConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:water_bucket");
            ConfigUpdater.removeConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:water_bucket");
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3")) {
            ConfigUpdater.replaceConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:magma_block", blockTemp -> {
                blockTemp.clear();
                blockTemp.addAll(List.of("minecraft:magma_block", Double.valueOf(0.25), Integer.valueOf(3), Double.valueOf(1.0)));
            });
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, 250));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:ice", iceFuel -> iceFuel.set(1, -250));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, 100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snow_block", snowFuel -> snowFuel.set(1, -100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, 100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:powder_snow_bucket", powderSnowFuel -> powderSnowFuel.set(1, -100));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.ICEBOX_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, 10));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.HEARTH_FUELS, "minecraft:snowball", snowballFuel -> snowballFuel.set(1, -10));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.1")) {
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:ice");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:packed_ice");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:blue_ice");
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.2")) {
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur", insulator -> insulator.set(0, "cold_sweat:goat_fur"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATION_ITEMS, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_cap", insulator -> insulator.set(0, "cold_sweat:goat_fur_cap"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_parka", insulator -> insulator.set(0, "cold_sweat:goat_fur_parka"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_pants", insulator -> insulator.set(0, "cold_sweat:goat_fur_pants"));
            ConfigUpdater.replaceConfigSetting(ItemSettingsConfig.INSULATING_ARMOR, "cold_sweat:fur_boots", insulator -> insulator.set(0, "cold_sweat:goat_fur_boots"));
        }
        if (ConfigUpdater.isBehind(configVersion, "2.3.4")) {
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_fire");
            ConfigUpdater.removeConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, "minecraft:soul_campfire");
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("cold_sweat:boiler", Double.valueOf(0.27), Integer.valueOf(7), Double.valueOf(0.88), "lit=true", "{}", Integer.valueOf(4)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("cold_sweat:icebox", Double.valueOf(-0.27), Integer.valueOf(7), Double.valueOf(0.88), "frosted=true", "{}", Integer.valueOf(0)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:ice", Double.valueOf(-0.15), Integer.valueOf(4), Double.valueOf(0.6), "", "{}", Double.valueOf(-0.7)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:packed_ice", Double.valueOf(-0.25), Integer.valueOf(4), Double.valueOf(1.0), "", "{}", Double.valueOf(-0.7)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("minecraft:blue_ice", Double.valueOf(-0.35), Integer.valueOf(4), Double.valueOf(1.4), "", "{}", Double.valueOf(-0.7)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("#minecraft:ice", Double.valueOf(-0.15), Integer.valueOf(4), Double.valueOf(0.6), "", "{}", Double.valueOf(-0.7)));
            ConfigUpdater.addConfigSetting(WorldSettingsConfig.BLOCK_TEMPERATURES, List.of("#minecraft:campfires", Double.valueOf(0.476), Integer.valueOf(7), Double.valueOf(0.9), "lit=true", " ", Integer.valueOf(8)));
        }
        MainSettingsConfig.getInstance().setVersion(version);
        MainSettingsConfig.getInstance().save();
        itemSettings.save();
        worldSettings.save();
    }

    private static boolean isBehind(String version, String comparedTo) {
        boolean isBehind;
        boolean bl = isBehind = ConfigUpdater.compareVersions(version, comparedTo) < 0;
        if (isBehind) {
            ColdSweat.LOGGER.warn("Last launched version {} is less than {}. Updating config settings...", (Object)version, (Object)comparedTo);
        }
        return isBehind;
    }

    public static int compareVersions(String version, String comparedTo) {
        int i;
        String[] v1Parts = version.split("\\.|\\-");
        String[] v2Parts = comparedTo.split("\\.|\\-");
        for (i = 0; i < v1Parts.length && i < v2Parts.length; ++i) {
            if (v1Parts[i].matches("\\d+") && v2Parts[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(v1Parts[i]);
                if (num1 == (num2 = Integer.parseInt(v2Parts[i]))) continue;
                return Integer.compare(num1, num2);
            }
            if (!v1Parts[i].startsWith("b") && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (v1Parts[i].startsWith("b") && !v2Parts[i].startsWith("b")) {
                return -1;
            }
            int result = ConfigUpdater.comparePreReleaseVersions(v1Parts[i], v2Parts[i]);
            if (result == 0) continue;
            return result;
        }
        if (v1Parts.length != v2Parts.length) {
            if (i == v1Parts.length && i < v2Parts.length && v2Parts[i].startsWith("b")) {
                return 1;
            }
            if (i == v2Parts.length && i < v1Parts.length && v1Parts[i].startsWith("b")) {
                return -1;
            }
        }
        return Integer.compare(v1Parts.length, v2Parts.length);
    }

    private static int comparePreReleaseVersions(String v1, String v2) {
        if (v1.startsWith("b") && v2.startsWith("b")) {
            return ConfigUpdater.compareWithSubVersions(v1.substring(1), v2.substring(1));
        }
        return v1.compareTo(v2);
    }

    private static int compareWithSubVersions(String v1, String v2) {
        String[] parts1 = v1.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        String[] parts2 = v2.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].matches("\\d+") && parts2[i].matches("\\d+")) {
                int num2;
                int num1 = Integer.parseInt(parts1[i]);
                if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
                return Integer.compare(num1, num2);
            }
            int result = parts1[i].compareTo(parts2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static void replaceConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, String key, Consumer<List<Object>> modifier) {
        ArrayList setting = new ArrayList((Collection)config.get());
        for (int i = 0; i < setting.size(); ++i) {
            ArrayList element = new ArrayList((Collection)setting.get(i));
            if (element.isEmpty() || !element.get(0).equals(key)) continue;
            try {
                modifier.accept(element);
                setting.set(i, element);
                config.set(setting);
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Failed to update config setting {} for key '{}'", (Object)config.getPath(), (Object)key, (Object)e);
            }
            break;
        }
    }

    public static void addConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<?>>> config, List<?> newSetting) {
        ArrayList setting = new ArrayList((Collection)config.get());
        if (setting.stream().noneMatch(entry -> !entry.isEmpty() && entry.get(0).equals(newSetting.get(0)))) {
            config.clearCache();
            setting.add(newSetting);
            config.set(setting);
        }
    }

    public static void removeConfigSetting(ForgeConfigSpec.ConfigValue<List<? extends List<? extends Object>>> config, String key) {
        ArrayList<List> setting = new ArrayList<List>((Collection)config.get());
        setting.removeIf(entry -> !entry.isEmpty() && entry.get(0).equals(key));
        config.set(setting);
    }
}

